import Link from "next/link";
import { useRouter } from "next/router";
import { useEffect, useState } from "react";
import { api } from "../../src/lib/api";
import { makeEcho } from "../../src/lib/echo";

export default function TicketChat() {
  const router = useRouter();
  const ticketId = Number(router.query.id);

  const [ticket, setTicket] = useState<any>(null);
  const [text, setText] = useState("");
  const [msg, setMsg] = useState("");

  const load = async () => {
    const t = await api<any>(`/api/tickets/${ticketId}`);
    setTicket(t);
  };

  useEffect(() => {
    if (!ticketId) return;
    load().catch(e=>setMsg(e.message));

    const echo = makeEcho();
    const ch = echo.private(`ticket.${ticketId}`);
    ch.listen(".ticket.message", () => load());
    return () => { echo.leave(`ticket.${ticketId}`); };
  }, [ticketId]);

  const send = async () => {
    setMsg("");
    await api(`/api/tickets/${ticketId}/messages`, { method:"POST", body: JSON.stringify({ message: text }) });
    setText("");
    await load();
  };

  if (!ticket) return <div style={{ padding:16 }}>Loading...</div>;

  return (
    <div style={{ maxWidth: 820, margin:"24px auto", padding:16 }}>
      <div style={{ display:"flex", justifyContent:"space-between" }}>
        <h2>Ticket #{ticket.id}</h2>
        <Link href="/tickets">Back</Link>
      </div>
      <p><b>{ticket.subject}</b> — {ticket.status}</p>
      {msg && <p>{msg}</p>}

      <div style={{ border:"1px solid #ddd", borderRadius:10, padding:12, height:360, overflow:"auto" }}>
        {ticket.messages?.map((m:any) => (
          <div key={m.id} style={{ marginBottom:10 }}>
            <div style={{ fontSize:12, opacity:0.7 }}>Sender: {m.sender_id} — {m.created_at}</div>
            <div>{m.message}</div>
          </div>
        ))}
      </div>

      <textarea value={text} onChange={(e)=>setText(e.target.value)} placeholder="Type..."
        style={{ width:"100%", padding:10, marginTop:10, height:100 }} />
      <button onClick={send} style={{ marginTop:10, padding:10 }}>Send</button>
    </div>
  );
}
